/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDProgressBar;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextEditorFrame
extends FmtFrameBase
implements ActionListener,
DocumentListener,
KeyListener {
    private CoFile m_file;
    private JEditorPane m_editor;
    private QDButton m_saveBtn;
    private boolean m_modified = false;
    private QDPanel m_statusPanel;
    private QDProgressBar m_progBar;
    private QDButton m_cancelBtn;
    private boolean m_doLoad = false;
    private boolean m_canceled = false;

    public TextEditorFrame(CoFile coFile) {
        super("", true, true, true, true);
        this.m_file = coFile;
        this.m_doLoad = true;
        this.initComponents();
    }

    private void initComponents() {
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        QDToolBar qDToolBar = new QDToolBar();
        this.m_saveBtn = new QDButton("  Save  ");
        this.m_saveBtn.setEnabled(false);
        this.m_saveBtn.setActionCommand("save");
        this.m_saveBtn.addActionListener((ActionListener)this);
        this.m_saveBtn.useSmallFont(true);
        this.m_saveBtn.setToolTipText("Save the data, overwriting the original file");
        this.m_saveBtn.setMnemonic(83);
        this.m_saveBtn.setDisplayedMnemonicIndex(2);
        qDToolBar.add((Component)this.m_saveBtn);
        qDPanel.add((Component)qDToolBar, (Object)"North");
        this.m_editor = new JEditorPane();
        this.m_editor.setFont(new Font("Monospaced", 0, 12));
        this.m_editor.setForeground(QDStdUI.getSelectedColor());
        this.m_editor.setCaretColor(QDStdUI.getActionForeground());
        this.m_editor.setSelectionColor(QDStdUI.getActionForeground());
        this.m_editor.setBackground(QDStdUI.getButtonDark());
        this.m_editor.setPreferredSize(new Dimension(400, 300));
        this.m_editor.getDocument().addDocumentListener(this);
        this.m_editor.addKeyListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_editor);
        qDPanel.add((Component)jScrollPane, (Object)"Center");
        this.m_statusPanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_progBar = new QDProgressBar();
        this.m_statusPanel.add((Component)this.m_progBar, (Object)"Center");
        this.m_cancelBtn = new QDButton("  Cancel  ");
        this.m_cancelBtn.useSmallFont(true);
        this.m_cancelBtn.setActionCommand("cancel");
        this.m_cancelBtn.addActionListener((ActionListener)this);
        this.m_statusPanel.add((Component)this.m_cancelBtn, (Object)"East");
        qDPanel.add((Component)this.m_statusPanel, (Object)"South");
        this.m_statusPanel.setVisible(false);
        this.getContentPane().add((Component)qDPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("save")) {
            this.saveFile();
        } else if (string.equals("cancel")) {
            this.m_canceled = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.modified();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.modified();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.modified();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 83) {
            this.saveFile();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void modified() {
        if (!this.m_modified) {
            this.m_modified = true;
            this.setFrameTitle();
            this.m_saveBtn.setEnabled(true);
        }
    }

    public String getDataName() {
        return this.m_file.getAbsolutePath();
    }

    public String getTypeName() {
        return "Text Editor";
    }

    public boolean isLocalFile() {
        return false;
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public boolean isSaveable() {
        return false;
    }

    public void markUnmodified() {
        this.m_modified = false;
    }

    public boolean supportsRemoteFiles() {
        return true;
    }

    public RemoteInstrument getInstrument() {
        return null;
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
    }

    public void setAsActive(boolean bl) {
        super.setAsActive(bl);
        if (this.m_doLoad && bl) {
            this.m_doLoad = false;
            this.m_canceled = false;
            this.m_statusPanel.setVisible(true);
            this.m_progBar.setValue(0);
            this.m_progBar.setString("0 of " + this.m_file.length());
            FileReader fileReader = new FileReader();
            new Thread(fileReader).start();
        }
    }

    public void setFrameTitle() {
        String string = this.m_modified ? " * " : "";
        String string2 = this.getTypeName() + ": " + string + this.getDataName();
        String string3 = this.m_file.getHost();
        if (string3.length() > 0) {
            this.setFrameTitle(string2 + " (" + string3 + ")");
        } else {
            this.setFrameTitle(string2);
        }
    }

    private void saveFile() {
        if (!this.m_saveBtn.isEnabled()) {
            return;
        }
        this.m_editor.setEnabled(false);
        this.m_saveBtn.setEnabled(false);
        this.m_canceled = false;
        this.m_statusPanel.setVisible(true);
        this.m_progBar.setValue(0);
        this.m_progBar.setString("Saving...");
        new Thread(new FileWriter()).start();
    }

    private class ProgUpdater
    implements Runnable {
        private int m_cnt;
        private String m_txt;

        public ProgUpdater(int n, String string) {
            this.m_cnt = n;
            this.m_txt = string;
        }

        public void run() {
            TextEditorFrame.this.m_progBar.setString(this.m_cnt + this.m_txt);
            TextEditorFrame.this.m_progBar.setValue(this.m_cnt);
        }
    }

    private class WriteFinish
    implements Runnable {
        private String m_errMsg;

        public WriteFinish(String string) {
            this.m_errMsg = string;
        }

        public void run() {
            if (this.m_errMsg != null) {
                MsgLog.error(this.m_errMsg);
                TextEditorFrame.this.m_saveBtn.setEnabled(true);
            } else {
                TextEditorFrame.this.m_saveBtn.setEnabled(false);
                TextEditorFrame.this.m_modified = false;
                TextEditorFrame.this.setFrameTitle();
            }
            TextEditorFrame.this.m_editor.setEnabled(true);
            TextEditorFrame.this.m_statusPanel.setVisible(false);
        }
    }

    private class FileWriter
    implements Runnable {
        private static final int MAX_CNT = 4096;

        private FileWriter() {
        }

        public void run() {
            String string = TextEditorFrame.this.m_editor.getText();
            byte[] byArray = string.getBytes();
            int n = 0;
            int n2 = byArray.length;
            String string2 = new String(" of " + n2);
            String string3 = null;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(TextEditorFrame.this.m_file.getOutputStream());
                while (n < n2 && !TextEditorFrame.this.m_canceled) {
                    int n3 = n2 - n < 4096 ? n2 - n : 4096;
                    bufferedOutputStream.write(byArray, n, n3);
                    SwingUtilities.invokeLater(new ProgUpdater(n += n3, string2));
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                string3 = "Write Failed: " + iOException.getMessage();
            }
            SwingUtilities.invokeLater(new WriteFinish(string3));
        }
    }

    private class ReadFinish
    implements Runnable {
        private StringBuffer m_buf;
        private String m_errMsg;

        public ReadFinish(StringBuffer stringBuffer, String string) {
            this.m_buf = stringBuffer;
            this.m_errMsg = string;
        }

        public void run() {
            if (this.m_errMsg != null) {
                MsgLog.error(this.m_errMsg);
            } else {
                TextEditorFrame.this.m_editor.setText(this.m_buf.toString());
                TextEditorFrame.this.m_modified = false;
                TextEditorFrame.this.m_saveBtn.setEnabled(false);
                TextEditorFrame.this.setFrameTitle();
            }
            TextEditorFrame.this.m_statusPanel.setVisible(false);
        }
    }

    private class FileReader
    implements Runnable {
        private FileReader() {
        }

        public void run() {
            byte[] byArray = new byte[1024];
            String string = new String(" of " + TextEditorFrame.this.m_file.length());
            StringBuffer stringBuffer = new StringBuffer(4096);
            String string2 = null;
            try {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(TextEditorFrame.this.m_file.getInputStream());
                int n2 = 0;
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0 && !TextEditorFrame.this.m_canceled) {
                    SwingUtilities.invokeLater(new ProgUpdater(n2 += n, string));
                    stringBuffer.append(new String(byArray, 0, n));
                }
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                string2 = "Read Failed: " + exception.getMessage();
            }
            SwingUtilities.invokeLater(new ReadFinish(stringBuffer, string2));
        }
    }
}

